class FaceDetector 
{
  constructor(video, frameRate, canvas ) {
    this.video = video;
    this.frameRate = frameRate;
    this.interval;
    this.events = {};
    this.takeImg = false;
    this.stopDetector = false;
    this.snap;
    this.canvasBox = canvas
    this.canvas2;
    this.canvas3;
    this.canvas4;
    this.canvasCapture;
    this._isPresent;
    this.firstPass = false;
  }

  get isPresent() {
    return this._isPresent;
  }

  start() {
    //this.stop(); // za svaki slucaj
    this.interval = setInterval(() => this.run(), this.frameRate);
  }

  stop() {
    clearInterval(this.interval);
  }

  async run() {

    const detectFace = await window.faceapi.detectSingleFace( this.video, new window.faceapi.TinyFaceDetectorOptions({ inputSize: 160 }) );

    // used to inform when the faceapi has loaded all modules
    if( !this.firstPass )
    {
      this.dispatchEvent("ready");
      this.firstPass = true;
    }

    if (detectFace) {
      this._isPresent = true;
      let difference = 0;
      let boxCord_X = detectFace.box.x;
      let boxCord_Y = detectFace.box.y;
      let boxW = detectFace.box.width;
      let boxH = detectFace.box.height;
      this.dispatchEvent("bounds", { x: boxCord_X, y: boxCord_Y, width: boxW, height: boxH });

      this.frameInBox(boxCord_X, boxCord_Y, boxW, boxH);
      let leftFacebrightness = this.leftSideBox(
        boxCord_X,
        boxCord_Y,
        boxW,
        boxH
      );
      let rightFacebrightness = this.rightSideBox(
        boxCord_X,
        boxCord_Y,
        boxW,
        boxH
      );
     
      if (leftFacebrightness > rightFacebrightness) {
        difference = leftFacebrightness - rightFacebrightness;
      } else if (rightFacebrightness > leftFacebrightness) {
        difference = rightFacebrightness - leftFacebrightness;
      }
      this.dispatchEvent("values", { leftSideLight: leftFacebrightness, rightSideLight: rightFacebrightness, difference: difference  });

    } else this._isPresent = false;
       
    this.dispatchEvent('face', { isPresent: this._isPresent });

  }

  sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
  }

  getSnapAndConvertToB64Img(x, y, w, h) {
    this.canvas2 = document.createElement("canvas");
    this.canvas2.width = w;
    this.canvas2.height = h;
    let ctx = this.canvas2.getContext("2d");
    ctx.drawImage(this.video, x, y, w, h, 0, 0, w, h);
    let dataURL = this.canvas2.toDataURL("image/png");
    return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
  }

  getSnapShot(x, y, w, h, canvas) {
    this.canvasCapture = canvas;
    this.canvasCapture.width = w;
    this.canvasCapture.height = h;
    let ctx = this.canvasCapture.getContext("2d");
    ctx.drawImage(this.video, x, y, w, h, 0, 0, w, h);
  }

  frameInBox(x, y, w, h) {
    this.canvas2 = document.createElement("canvas");
    this.canvas2.id =  "canvas-selfe"
    this.canvas2.width = w;
    this.canvas2.height = h;
    let ctx = this.canvas2.getContext("2d");
    ctx.drawImage(this.video, x, y, w, h, 0, 0, w, h);
  }

  rightSideBox(x, y, w, h) {
    let colorSum = 0;
    this.canvas3 = document.createElement("canvas");
    this.canvas3.width = w / 2;
    this.canvas3.height = h;
    let ctx = this.canvas3.getContext("2d");
    ctx.drawImage(this.video, x, y, w / 2, h, 0, 0, w / 2, h);
    let imageData = ctx.getImageData(
      0,
      0,
      this.canvas3.width,
      this.canvas3.height
    );
    let data = imageData.data;
    let r, g, b, avg;

    for (let x = 0, len = data.length; x < len; x += 4) {
      r = data[x];
      g = data[x + 1];
      b = data[x + 2];

      avg = Math.floor((r + g + b) / 3);
      colorSum += avg;
    }

    let brightness = Math.floor(
      colorSum / (this.canvas3.width * this.canvas3.height)
    );

    return brightness;
  }

  leftSideBox(x, y, w, h) {
    let colorSum = 0;
    this.canvas4 = document.createElement("canvas");
    this.canvas4.width = w/2 ;
    this.canvas4.height = h;
    let ctx = this.canvas4.getContext("2d");
    ctx.drawImage(this.video, x , y , w , h, -(w/2), 0, w , h);

    let imageData = ctx.getImageData(
      0,
      0,
      this.canvas4.width,
      this.canvas4.height
    );
    let data = imageData.data;
    let r, g, b, avg;

    for (let x = 0, len = data.length; x < len; x += 4) {
      r = data[x];
      g = data[x + 1];
      b = data[x + 2];

      avg = Math.floor((r + g + b) / 3);
      colorSum += avg;
    }

    let brightness = Math.floor(
      colorSum / (this.canvas4.width * this.canvas4.height)
    );

    return brightness;
  }

  destroy() {}

  /// EVENT HANDLING

  addEventListener(name, handler) {
    if (typeof handler != "function") return;
    if (!this.events[name]) this.events[name] = [];
    this.events[name].push(handler);
  }

  removeEventListener(name, handler) {
    if (!this.events[name]) return;
    handler = this.events[name];

    handler.forEach((f, i) => {
      if (f !== handler) return;
      this.events[name] = handler.splice(i, 1);
    });
  }

  dispatchEvent(name, args) {
    if (!this.events[name]) return;
    this.events[name].forEach((e) => e(args || {}));
  }
}
